#include <jni.h>
#include "../../../c/android/fac.h"
#include <cstddef>
///////////////////////////////////////////////////////////////////////////////////////////
namespace com_example_issm
{
	fac* f;
//------------------------------------------------------------------------------------
	void initilizeObject(JNIEnv *env, jclass clazz)
	{
		f = new fac();
	}
//------------------------------------------------------------------------------------
	//fill out the first two slots, extract the same way in java using get(int position)
	void fillBuffer(JNIEnv *env, jclass clazz , jobject buf)
	{
		jdouble *bBuf = (jdouble *)env->GetDirectBufferAddress(buf);
		bBuf[1] = 10.67;
		bBuf[2] = 100.0;
	}
//------------------------------------------------------------------------------------
	jlong factorial(JNIEnv *env, jclass clazz, jlong n)
	{
		if( f != NULL)
			return (jlong) (f->factorial(n));
		return 0;
	}

//------------------------------------------------------------------------------------
	static JNINativeMethod method_table[] =
	{
			{"fac"      	,     "(J)J" 	, (void *) factorial},
			{"initialize"   ,     "()V" 	, (void *) initilizeObject},
			{"processBuffer", "(Ljava/nio/DoubleBuffer;)V", (void *) fillBuffer}
	};
}
//------------------------------------------------------------------------------------
using namespace com_example_issm;

extern "C" jint JNI_OnLoad(JavaVM* vm, void* reserved)
{
    JNIEnv* env;
    if (vm->GetEnv(reinterpret_cast<void**>(&env), JNI_VERSION_1_6) != JNI_OK) {
        return -1;
    }
    else
    {
    	jclass clazz = env->FindClass("com/example/issm/IssmJni");
    	if(clazz)
    	{
    		env->RegisterNatives(clazz, method_table, 3);
    		env->DeleteLocalRef(clazz);
    		return JNI_VERSION_1_6;
    	}
    	else return -1;
    }

    // Get jclass with env->FindClass.
    // Register methods with env->RegisterNatives.
}
///////////////////////////////////////////////////////////////////////////////////////////
