package com.example.issm;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;

import android.os.Bundle;
import android.app.Activity;
import android.content.res.AssetManager;
import android.text.TextUtils;
import android.view.Menu;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;


public class ISSM extends Activity implements OnClickListener 
{
	private EditText input;
	private TextView output;
	private DoubleBuffer buff;
	private IssmJni issmNative;
	private String mapName;
	private String textinFile;
	private String actualinput;
    @Override
  //------------------------------------------------------------------------------------------------    
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle map = getIntent().getExtras();
        {
        	if(map!= null)
        	{
        		mapName = map.getString("map");
        	}
        }
        setContentView(R.layout.activity_issm);
        this.input  = (EditText) super.findViewById(R.id.input);
        this.output  = (TextView) super.findViewById(R.id.output);
        Button button = (Button) super.findViewById(R.id.button1);
        button.setOnClickListener(this);
        this.readFile(mapName);
        
        //load up the ISSM library and create double buffer in java
        //which later on will be pass for native allocation.
        issmNative = new IssmJni();
        buff = ByteBuffer.allocateDirect(15*8).order(ByteOrder.nativeOrder()).asDoubleBuffer();
        this.createModel("Model");
    }
//------------------------------------------------------------------------------------------------    
    public void createModel(String Model)
    {
    	issmNative.initialize();
    }
//------------------------------------------------------------------------------------------------
    public void readFile(String mapName)
    {
    	AssetManager am = getAssets();
    	String mapNameFile = "Map/"+mapName+".txt";
        try {
			InputStream is = am.open(mapNameFile);
			int size = is.available();
			byte[]buffer = new byte[size];
			is.read(buffer);
			is.close();
			
			textinFile = new String(buffer);
			
			//testing on actual file
			InputStream is1 = am.open("Map/test102.petsc");
			int size1 = is1.available();
			byte[]buffer1 = new byte[size1];
			is1.read(buffer1);
			System.out.println(buffer1);
			is1.close();
			actualinput = new String(buffer1);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
    }
//------------------------------------------------------------------------------------------------
    public void fillBuffer()
    {
    	issmNative.processBuffer(buff);
    }
 //------------------------------------------------------------------------------------------------   
    public void onClick(View view) 
	{
		//factorial method
		String input = this.input.getText().toString();
		if(TextUtils.isEmpty(input))
		{
			return;
		}		
		long resultfromFac = issmNative.fac(Long.parseLong(input));
		//example of how to fill buffer Native
		this.fillBuffer();
		
		//print result from fac and the first two slot of filled buffer.
		this.output.setText("Result = " + resultfromFac + "\n" 
										+ "First two slot from buffer:\n" 
										+ buff.get(1) + "          " + buff.get(2) 
										+ "\nmap name = " + mapName
										+ "\nTxtFile    " + textinFile
										+"\nactualFile   " + actualinput);

	}
}
