function triaelem = triaelem(varargin)
%BEAMELEM - contructor for triaelem objects
%
%   Usage:
%      triaelem = triaelem(varargin)

switch nargin
case 0
	% if no input arguments, create a default object
	triaelem.type='triaelem';
	triaelem.id=NaN;
	triaelem.matid=NaN;
	triaelem.g=zeros(3,1);
	triaelem.h=zeros(3,1);
	triaelem.s=zeros(3,1);
	triaelem.b=zeros(3,1);
	triaelem.friction_type=2;
	triaelem.viscosity_overshoot=0;
	triaelem.ontiling=0;
	triaelem.k=zeros(3,1);
	triaelem.p=1;
	triaelem.q=1;
	triaelem.shelf=NaN;
	triaelem.meanvel=NaN;
	triaelem.epsvel=NaN;
	triaelem.artificial_diffusivity=0;
	
	triaelem=class(triaelem,'triaelem');
				
case 1
	%If single argument of class triaelem, we have a copy constructor. 
	if (isa(varargin{1},'triaelem'))
		triaelem = varargin{1};
	else
		error('triaelem constructor error message: copy constructor called on a non ''triaelem'' class object');
	end 
otherwise
	error('triaelem constructor error message: 0 of 1 argument only in input.');
end
