function pentaelem = pentaelem(varargin)
%PENTAELEM - contructor for pentaelem objects
%
%   Usage:
%      pentaelem = pentaelem(varargin)

switch nargin
case 0
	% if no input arguments, create a default object
	pentaelem.type='pentaelem';
	pentaelem.id=NaN;
	pentaelem.matid=NaN;
	pentaelem.g=zeros(6,1);
	pentaelem.h=zeros(6,1);
	pentaelem.s=zeros(6,1);
	pentaelem.b=zeros(6,1);
	pentaelem.friction_type=2;
	pentaelem.viscosity_overshoot=0;
	pentaelem.ontiling=0;
	pentaelem.k=zeros(6,1);
	pentaelem.p=1;
	pentaelem.q=1;
	pentaelem.shelf=NaN;
	pentaelem.onbed=NaN;
	pentaelem.onsurface=NaN;
	pentaelem.meanvel=NaN;
	pentaelem.epsvel=NaN;
	pentaelem.collapse=0;
	pentaelem.melting=zeros(6,1);
	pentaelem.accumulation=zeros(6,1);
	pentaelem.geothermalflux=zeros(6,1);
	pentaelem.artificial_diffusivity='no';
	pentaelem.thermal_steadystate=1;
	pentaelem.reconditioning_number=NaN;
	
	pentaelem=class(pentaelem,'pentaelem');
				
case 1
	%If single argument of class pentaelem, we have a copy constructor. 
	if (isa(varargin{1},'pentaelem'))
		pentaelem = varargin{1};
	else
		error('pentaelem constructor error message: copy constructor called on a non ''pentaelem'' class object');
	end 
otherwise
	error('pentaelem constructor error message: 0 of 1 argument only in input.');
end
