function Bprime=GetBprime_melange(pentaelem,xyz_list,gauss_coord)
%GETBPRIME_MELANGE - compute the Bprime matrix for horizontal velocities in Pattyn's model
%
%   Compute B'  matrix. B'=[B1' B2' B3' B4' B5' B6'] where Bi' is of size 3*NDOF2. 
%   For grid i, Bi' can be expressed in the basic coordinate system by:
%   Bi_basic'=[ 2*dh/dx    dh/dy ]
%             [   dh/dx   2*dh/dy]
%             [   dh/dy   dh/dx  ]
%   where h is the interpolation function for grid i.
%
%   Usage:
%      Bprime=GetBprime_horiz(pentaelem,xyz_list,gauss_coord)
%
%   See also GETB_HORIZ, CREATEKMATRIX

	num_grids=6;	
	NDOF2=2;

	dh1dh6_basic=GetNodalFunctionsDerivativesBasic(pentaelem,xyz_list,gauss_coord);

	%Build Bprime:
	Bprime=zeros(3,NDOF2*num_grids);
	for i=1:num_grids,
		Bprime(1,NDOF2*(i-1)+1)=2*dh1dh6_basic(1,i);
		Bprime(1,NDOF2*(i-1)+2)=  dh1dh6_basic(2,i);
		Bprime(2,NDOF2*(i-1)+1)=  dh1dh6_basic(1,i);
		Bprime(2,NDOF2*(i-1)+2)=2*dh1dh6_basic(2,i);
		Bprime(3,NDOF2*(i-1)+1)=dh1dh6_basic(2,i);
		Bprime(3,NDOF2*(i-1)+2)=dh1dh6_basic(1,i);		
	end
