function plot_scatter(x,y,level,varargin),

options=pairoptions(varargin{:}); 

%check input
if numel(x)~=numel(y) | numel(x)~=numel(level),
	error('x, y and data should have the same size');
end

%Some processing
Min=min(level);
Max=max(level);
Siz=length(level);
nlab=10;
%Min=0;
%Max=1300;

%OK, should we create a new colorbar for the occasion?
if isempty(findobj(gcf,'tag','TMW_COLORBAR')),
	alreadyplot=false;
else
	alreadyplot=true;
end

%generate levels
if (alreadyplot),
	phch = get(findall(gcf,'type','image','tag','TMW_COLORBAR'),{'parent'});
	h    = phch{1};
	ylim=get(h,'YLim');
	palette=colormap;
	numcolors=size(palette,1);
	levels=round_ice(linspace(ylim(1),ylim(2),numcolors+1),2);
else
	palette=getcolormap(options);
	numcolors=size(palette,1);
	levels=round_ice(linspace(Min,Max,numcolors+1),2);
end

colorind=ones(Siz,1);
for i=1:numcolors
	pos=find((level>=levels(i)) & (level<=levels(i+1)) );
	colorind(pos)=i;
end
colorind(find(level>levels(end)))=numcolors;

%loop over the number of colors
hold on
hp=[];
for i=1:numcolors
	pos=find(colorind==i);
	hprime=plot3(x(pos),y(pos),ones(size(x(pos))),...
		'o','MarkerSize',getfieldvalue(options,'MarkerSize',3),'MarkerEdgeColor',palette(i,:),...
		'MarkerFaceColor',palette(i,:));
	hp=[hp;hprime];
end

if ~alreadyplot,
	% format the colorbar
	h    = colorbar;
	caxis([min(levels) max(levels)]);
end
