function md=tres(md,string)
%TRES - transfer results results to corresponding model fields. 
%
%    Usage: md=tres(md,string)
%
%    Example: md=tres(md,'diagnostic');

%check number of arguments

if strcmpi(string,'diagnostic'),
	if md.mesh.dimension==2,
		md.initialization.vx=md.results.DiagnosticSolution.Vx;
		md.initialization.vy=md.results.DiagnosticSolution.Vy;
	else 
		md.initialization.vx=md.results.DiagnosticSolution.Vx;
		md.initialization.vy=md.results.DiagnosticSolution.Vy;
		md.initialization.vz=md.results.DiagnosticSolution.Vz;
	end
	md.initialization.vel=md.results.DiagnosticSolution.Vel;

	if isfield(md.results.DiagnosticSolution,'Pressure'),
		md.initialization.pressure=md.results.DiagnosticSolution.Pressure;
	end
	if ~isempty(md.rifts.riftstruct),
		if isfield(md.results.DiagnosticSolution,'riftproperties'),
			md.rifts.riftproperties=md.results.DiagnosticSolution.riftproperties;
		end
	end

elseif strcmpi(string,'dakota'),
	md.qmu.results=md.results.dakota;

elseif strcmpi(string,'flaim'),
	md.flaim.solution=md.results.FlaimSolution.solution;
	md.flaim.quality =md.results.FlaimSolution.quality;

elseif strcmpi(string,'transient'),
	results=md.results.TransientSolution;
	results2.Vel=NaN;
	count=1;
	for i=1:length(results),
		if ~isempty(md.results.TransientSolution(i).Vel),
			results2(count).Vel=md.results.TransientSolution(i).Vel;
			results2(count).Surface=md.results.TransientSolution(i).Surface;
			results2(count).Thickness=md.results.TransientSolution(i).Thickness;
			results2(count).Bed=md.results.TransientSolution(i).Bed;
			results2(count).Vx=md.results.TransientSolution(i).Vx;
			results2(count).Vy=md.results.TransientSolution(i).Vy;
			results2(count).time=md.results.TransientSolution(i).time;
			results2(count).step=md.results.TransientSolution(i).step;
			if ~strcmpi(md.groundingline.migration,'None'),
				results2(count).ElementOnIceShelf=md.results.TransientSolution(i).ElementOnIceShelf;
			end
			count=count+1;
		end
	end
	md.results.TransientSolution=results2;
	clear results,results2;
elseif strcmpi(string,'steadystate'),
	md.initialization.vx=md.results.SteadystateSolution.Vx;
	md.initialization.vy=md.results.SteadystateSolution.Vy;
	if isfield(md.results.SteadystateSolution,'Vz'),
		md.initialization.vz=md.results.SteadystateSolution.Vz;
	end

	md.initialization.vel=md.results.SteadystateSolution.Vel;
	md.initialization.pressure=md.results.SteadystateSolution.Pressure;
	md.initialization.temperature=md.results.SteadystateSolution.Temperature;
	md.basalforcings.melting_rate=md.results.SteadystateSolution.BasalforcingsMeltingRate;

	if md.inversion.iscontrol==1,
		for control_parameters=md.inversion.control_parameters
			md.(EnumToModelField(control_parameters))=md.results.SteadystateSolution.(EnumToString(control_parameters));
		end
	end

elseif strcmpi(string,'thermal'),
	md.initialization.temperature=md.results.ThermalSolution.Temperature;
	md.basalforcings.melting_rate=md.results.ThermalSolution.BasalMeltingRate;
elseif strcmpi(string,'hydrology'),
	md.initialization.watercolumn=md.results.HydrologySolution.Watercolumn;

else 
	error(['tres error message: analysis ' string ' not supported yet!']);
end
end 
function string=EnumToModelField(enum) % {{{
	%ENUMTOMODELFIELD - output string of model field associated to enum
	%
	%   Usage:
	%      string=EnumToModelField(enum)

	disp('Warning: EnumToModelField is deprecated, it cannot work with new model definition. This function will be removed in the future');

	switch enum,

		case ThicknessEnum(), string='thickness'; return
		case FrictionCoefficientEnum(), string='drag_coefficient'; return
		case MaterialsRheologyBEnum(), string='rheology_B'; return
		case MaterialsRheologyBbarEnum(), string='rheology_B'; return
		case MaterialsRheologyZEnum(), string='rheology_Z'; return
		case MaterialsRheologyZbarEnum(), string='rheology_Z'; return
		case BalancethicknessThickeningRateEnum(), string='dhdt'; return
		case VxEnum(), string='vx'; return
		case InversionVxObsEnum(), string='vx_obs'; return
		case VyEnum(), string='vy'; return
		case InversionVyObsEnum(), string='vy_obs'; return
		case BasalforcingsMeltingRateEnum(), string='basal_melting_rate'; return
		case SurfaceforcingsAccumulationRateEnum(), string='surface_accumulation_rate'; return
		case SurfaceforcingsAblationRateEnum(), string='surface_ablation_rate'; return
		case SurfaceforcingsMassBalanceEnum(), string='surface_mass_balance'; return
		otherwise, error(['Enum ' num2str(enum)  ' not found associated to any model field']);

		end
	end % }}}
