/* \file PetscMatrixToDoubleMatrix.cpp
 * \brief: convert a sparse or dense Petsc matrix into a matlab matrix
 */

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <string>

/*Petsc includes: */
#include <petscmat.h>
#include <petscvec.h>
#include <petscksp.h>

/*Petsc includes: */
#include "../../../shared/shared.h"

void PetscMatrixToDoubleMatrix(double** pmatrix, int* prows, int* pcols,Mat petsc_matrix){

	/*output: */
	int     i;
	double* matrix=NULL;
	int     rows,cols;

	/*Some needed information: */
	MatGetSize(petsc_matrix,&rows,&cols);

	int* idxm=xNew<int>(rows);
	int* idxn=xNew<int>(cols);

	for(i=0;i<rows;i++)idxm[i]=i;
	for(i=0;i<cols;i++)idxn[i]=i;

	matrix=xNew<double>(rows*cols);
	MatGetValues(petsc_matrix,rows,idxm,cols,idxn,matrix);

	xDelete<int>(idxm);
	xDelete<int>(idxn);

	/*Assign output pointers: */
	*pmatrix=matrix;
	*prows=rows;
	*pcols=cols;
}
