/*!\file:  EnvironmentInit.cpp
 * \brief: initialize Petsc, MPI, you name it
 */ 
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif
#include <stdio.h>
#include "../include/include.h"
#include "../toolkits/toolkits.h"

COMM EnvironmentInit(int argc,char** argv){

	/*Output*/
	COMM comm = 0;

	/*Initialize MPI environment: */
	#if defined(_HAVE_MPI_)
	MPI_Init(&argc,&argv);
	comm = MPI_COMM_WORLD;
	#else
	comm = 1; //bogus number for comm, which does not exist anyway.
	#endif

	/*Print Banner*/
	int my_rank = 0;
	#ifdef _HAVE_MPI_
	MPI_Comm_rank(comm,&my_rank);
	#endif
	if(!my_rank) printf("\n");
	if(!my_rank) printf("Ice Sheet System Model (%s) version  %s\n",PACKAGE_NAME,PACKAGE_VERSION);
	if(!my_rank) printf("(website: %s contact: %s\n",PACKAGE_URL,PACKAGE_BUGREPORT);
	if(!my_rank) printf("\n");

	/*Return communicator*/
	return comm;
}
