/*!\file:  ElementResult.h
 * \brief abstract class for ElementResult object
 */ 

#ifndef _ELEMENTRESULT_H_
#define _ELEMENTRESULT_H_

/*Headers:*/
/*{{{*/
#include "../Object.h"
/*}}}*/

class ElementResult:public Object{

	public: 

		virtual        ~ElementResult(){};
		virtual         ElementResult* SpawnTriaElementResult(int* indices)=0;
		virtual IssmDouble  GetTime(void)=0;
		virtual int     GetStep(void)=0;
		virtual void    ProcessUnits(Parameters* parameters)=0;
		virtual int     NumberOfNodalValues(void)=0;
		virtual void    PatchFill(int row, Patch* patch)=0;
		virtual int     InstanceEnum()=0;
		virtual void    GetVectorFromResults(Vector<IssmDouble>* vector,int* doflist,int* connectivitylist,int numdof)=0;
		virtual void    GetElementVectorFromResults(Vector<IssmDouble>* vector,int dof)=0;

};

#endif
