/*!\file: Nodes.h
 * \brief prototypes for Nodes.h
 */ 

#ifndef _CONTAINER_NODES_H_
#define  _CONTAINER_NODES_H_

#include "./DataSet.h"

/*forward declarations */
class Nodes: public DataSet{

	public:

		/*constructors, destructors*/
		Nodes();
		~Nodes();

		/*numerics*/
		void  Configure(Elements* elements,Loads* loads, Nodes* nodes, Vertices* vertices, Materials* materials,Parameters* parameters);
		void  DistributeDofs(int analysis_type,int SETENUM);
		void  FlagClones(int analysis_type);
		int   MaxNumDofs(int analysis_type,int setenum);
		int   NumberOfDofs(int analysis_type,int setenum);
		int   NumberOfDofsLocal(int analysis_type,int setenum);
		int   NumberOfNodes(int analysis_type);
		int   NumberOfNodes(void);
		void  Ranks(int* ranks,int analysis_type);
		void  SetCurrentConfiguration(Elements* elements,Loads* loads, Nodes* nodes, Vertices* vertices, Materials* materials,Parameters* parameters);

};

#endif //ifndef _NODES_H_
