/*
 * Copyright (C) 2012 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.example.issm_visual;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

import android.opengl.GLES20;
import android.opengl.GLSurfaceView;

public class MyGLRenderer implements GLSurfaceView.Renderer {

    private Triangle mTriangle1, mTriangle2, mTriangle3;

    @Override
    public void onSurfaceCreated(GL10 unused, EGLConfig config) {

        // Set the background frame color
        GLES20.glClearColor(1.0f, 1.0f, 1.0f, 1.0f);

        mTriangle1 = new Triangle(
        0.0f,  0.6f, 0.0f,   // top
       -0.5f, -0.3f, 0.0f,   // bottom left
        0.5f, -0.3f, 0.0f,
        0.0f, 0.0f, 1.0f, 1.0f);   // bottom right
        //mTriangle = new Triangle();
        
        mTriangle2 = new Triangle(
        -0.5f, -0.3f, 0.0f,
         0.0f, -1.0f, 0.0f,
         0.5f,  -0.3f, 0.0f,
         1.0f, 0.0f, 0.0f, 1.0f);
        
        mTriangle3 = new Triangle(
        0.0f,  0.6f, 0.0f,
        0.5f, -0.3f, 0.0f,
        1.0f,  0.6f, 0.0f,
        1.0f, 1.0f, 0.0f, 1.0f);
    }

    @Override
    public void onDrawFrame(GL10 unused) {

        // Draw background color
        GLES20.glClear(GLES20.GL_COLOR_BUFFER_BIT);

        // Draw triangle
        mTriangle1.draw(); 
        mTriangle2.draw();
        mTriangle3.draw();
    }

    @Override
    public void onSurfaceChanged(GL10 unused, int width, int height) {
        // Adjust the viewport based on geometry changes,
        // such as screen rotation
        GLES20.glViewport(0, 0, width, height);
    }

    public static int loadShader(int type, String shaderCode){

        // create a vertex shader type (GLES20.GL_VERTEX_SHADER)
        // or a fragment shader type (GLES20.GL_FRAGMENT_SHADER)
        int shader = GLES20.glCreateShader(type);

        // add the source code to the shader and compile it
        GLES20.glShaderSource(shader, shaderCode);
        GLES20.glCompileShader(shader);

        return shader;
    }

}

class Triangle 
{

    private final String vertexShaderCode =
        "attribute vec4 vPosition;" +
        "void main() {" +
        "  gl_Position = vPosition;" +
        "}";

    private final String fragmentShaderCode =
        "precision mediump float;" +
        "uniform vec4 vColor;" +
        "void main() {" +
        "  gl_FragColor = vColor;" +
        "}";

    private final FloatBuffer vertexBuffer;
    private final int mProgram;
    private int mPositionHandle;
    private int mColorHandle;

    // number of coordinates per vertex in this array
    static final int COORDS_PER_VERTEX = 3;
    float triangleCoords[] ; /*){ // in counterclockwise order:
         0.0f,  0.6f, 0.0f,   // top
        -0.5f, -0.3f, 0.0f,   // bottom left
         0.5f, -0.3f, 0.0f};  */ // bottom right
         
        /* -0.55f, -0.35f, 0.0f,
         0.0f, -1.2f, 0.0f,
         0.55f,  -0.35f, 0.0f
    };*/
    
    private final int vertexCount = 9 / COORDS_PER_VERTEX;
    private final int vertexStride = COORDS_PER_VERTEX * 4; // bytes per vertex

    // Set color with red, green, blue and alpha (opacity) values
    float color[];
    //private final FloatBuffer colorBuffer;
    private final int colorCount = 4/COORDS_PER_VERTEX;
    
    public Triangle() 
    {
        // initialize vertex byte buffer for shape coordinates
        ByteBuffer bb = ByteBuffer.allocateDirect(
                // (number of coordinate values * 4 bytes per float)
                triangleCoords.length * 4);
        // use the device hardware's native byte order
        bb.order(ByteOrder.nativeOrder());

        // create a floating point buffer from the ByteBuffer
        vertexBuffer = bb.asFloatBuffer();
        // add the coordinates to the FloatBuffer
        vertexBuffer.put(triangleCoords);
        // set the buffer to read the first coordinate
        vertexBuffer.position(0);

        /*ByteBuffer bb1 = ByteBuffer.allocateDirect(color.length*4);
        bb1.order(ByteOrder.nativeOrder());
        colorBuffer = bb1.asFloatBuffer();
        colorBuffer.put(color);
        colorBuffer.position(0);*/
        
        //GLES20.glEnableVertexAttribArray(1);
        //GLES20.glBindBuffer(GLES20.GL_ARRAY_BUFFER, colorBuffer);
        
        // prepare shaders and OpenGL program
        int vertexShader = MyGLRenderer.loadShader(GLES20.GL_VERTEX_SHADER,
                                                   vertexShaderCode);
        int fragmentShader = MyGLRenderer.loadShader(GLES20.GL_FRAGMENT_SHADER,
                                                     fragmentShaderCode);

        mProgram = GLES20.glCreateProgram();             // create empty OpenGL Program
        GLES20.glAttachShader(mProgram, vertexShader);   // add the vertex shader to program
        GLES20.glAttachShader(mProgram, fragmentShader); // add the fragment shader to program
        GLES20.glLinkProgram(mProgram);                  // create OpenGL program executables
    }
    public Triangle(float x1, float y1, float z1,
    			    float x2, float y2, float z2,
    			    float x3, float y3, float z3,
    			    float c1, float c2, float c3, float c4) 
    {
    	triangleCoords = new float[9];
    	color = new float[4];
    	triangleCoords[0] = x1;
    	triangleCoords[1] = y1;
    	triangleCoords[2] = z1;
    	triangleCoords[3] = x2;
    	triangleCoords[4] = y2;
    	triangleCoords[5] = z2;
    	triangleCoords[6] = x3;
    	triangleCoords[7] = y3;
    	triangleCoords[8] = z3;
    	color[0] = c1;
    	color[1] = c2;
    	color[2] = c3;
    	color[3] = c4;
        // initialize vertex byte buffer for shape coordinates
        ByteBuffer bb = ByteBuffer.allocateDirect(
                // (number of coordinate values * 4 bytes per float)
                triangleCoords.length * 4);
        // use the device hardware's native byte order
        bb.order(ByteOrder.nativeOrder());

        // create a floating point buffer from the ByteBuffer
        vertexBuffer = bb.asFloatBuffer();
        // add the coordinates to the FloatBuffer
        vertexBuffer.put(triangleCoords);
        // set the buffer to read the first coordinate
        vertexBuffer.position(0);

        /*ByteBuffer bb1 = ByteBuffer.allocateDirect(color.length*4);
        bb1.order(ByteOrder.nativeOrder());
        colorBuffer = bb1.asFloatBuffer();
        colorBuffer.put(color);
        colorBuffer.position(0);*/
           
        // prepare shaders and OpenGL program
        int vertexShader = MyGLRenderer.loadShader(GLES20.GL_VERTEX_SHADER,
                                                   vertexShaderCode);
        int fragmentShader = MyGLRenderer.loadShader(GLES20.GL_FRAGMENT_SHADER,
                                                     fragmentShaderCode);

        mProgram = GLES20.glCreateProgram();             // create empty OpenGL Program
        GLES20.glAttachShader(mProgram, vertexShader);   // add the vertex shader to program
        GLES20.glAttachShader(mProgram, fragmentShader); // add the fragment shader to program
        GLES20.glLinkProgram(mProgram);                  // create OpenGL program executables
    }

    public void draw() 
    {
        // Add program to OpenGL environment
        GLES20.glUseProgram(mProgram);

        // get handle to vertex shader's vPosition member
        mPositionHandle = GLES20.glGetAttribLocation(mProgram, "vPosition");

        // Enable a handle to the triangle vertices
        GLES20.glEnableVertexAttribArray(mPositionHandle);

        // Prepare the triangle coordinate data
        GLES20.glVertexAttribPointer(mPositionHandle, COORDS_PER_VERTEX,
                                     GLES20.GL_FLOAT, false,
                                     vertexStride, vertexBuffer);

        // get handle to fragment shader's vColor member
        mColorHandle = GLES20.glGetUniformLocation(mProgram, "vColor");

        // Set color for drawing the triangle
        //GLES20.glUniform4fv(mColorHandle, 0, color, 0);
        //GLES20.glVertexAttrib4f(0, 0.5f, 0.5f, 0.0f, 1.0f);
        //GLES20.glVertexAttribPointer(mPositionHandle, 4, GLES20.GL_FLOAT, false, stride, offset)
        GLES20.glUniform4fv(mColorHandle, 1, color, 0);
        // Draw the triangle
        GLES20.glDrawArrays(GLES20.GL_TRIANGLES, 0, vertexCount);
    }
}
