import numpy
from model import *
from EnumDefinitions import *
from MatlabFuncs import *
from triangle import *
from meshconvert import *
from setmask import *
from parameterize import *
from setflowequation import *
from solve import *

md=triangle(model(),'../Exp/79North.exp',10000.)
md=meshconvert(md)
md=setmask(md,'../Exp/79NorthShelf.exp','')
md=parameterize(md,'../Par/79North.py')
md=setflowequation(md,'macayeal','all')
md.prognostic.stabilization=3
md.prognostic.spcthickness=md.geometry.thickness
md.cluster=generic('name',oshostname(),'np',3)
md=solve(md,PrognosticSolutionEnum())

#Fields and tolerances to track changes
field_names     =['Thickness']
field_tolerances=[1e-13]
field_values=[\
	md.results.PrognosticSolution.Thickness,\
	]
