from model import *
from triangle import *
from setmask import *
from parameterize import *
from setflowequation import *
from EnumDefinitions import *
from solve import *
from MatlabFuncs import *

md=triangle(model(),'../Exp/Pig.exp',30000.)
md=setmask(md,'../Exp/PigShelves.exp','../Exp/PigIslands.exp')
md=parameterize(md,'../Par/Pig.py')
md.extrude(3,1.)
md=setflowequation(md,'pattyn','all')
md.thermal.stabilization=2
md.cluster=generic('name',oshostname(),'np',3)
md.transient.isdiagnostic=0
md.transient.isprognostic=0
md.transient.isthermal=1
md.transient.isgroundingline=0
md=solve(md,TransientSolutionEnum())

# Fields and tolerances to track changes
field_names     =['Temperature1','BasalforcingsMeltingRate1', \
				      'Temperature2','BasalforcingsMeltingRate2']
field_tolerances=[1e-13,1e-8,1e-13,1e-8]
field_values=[\
	md.results.TransientSolution[0].Temperature,\
	md.results.TransientSolution[0].BasalforcingsMeltingRate,\
	md.results.TransientSolution[1].Temperature,\
	md.results.TransientSolution[1].BasalforcingsMeltingRate,\
	]
