from model import *
from triangle import *
from setmask import *
from parameterize import *
from setflowequation import *
from EnumDefinitions import *
from solve import *
from MatlabFuncs import *

md=triangle(model(),'../Exp/Pig.exp',20000.)
md=setmask(md,'../Exp/PigShelves.exp','../Exp/PigIslands.exp')
md=parameterize(md,'../Par/Pig.py')
md.extrude(3,0.9)
md=setflowequation(md,'pattyn','all')
md.cluster=generic('name',oshostname(),'np',3)
md=solve(md,DiagnosticSolutionEnum())

# Fields and tolerances to track changes
field_names     =['Vx','Vy','Vz','Vel','Pressure']
field_tolerances=[1e-08,1e-08,1e-08,1e-08,1e-08]
field_values=[\
	md.results.DiagnosticSolution.Vx,\
	md.results.DiagnosticSolution.Vy,\
	md.results.DiagnosticSolution.Vz,\
	md.results.DiagnosticSolution.Vel,\
	md.results.DiagnosticSolution.Pressure,\
	]
