import numpy
from model import *
from EnumDefinitions import *
from MatlabFuncs import *
from triangle import *
from setmask import *
from parameterize import *
from setflowequation import *
from solve import *

md=triangle(model(),'../Exp/Square.exp',150000.)
md=setmask(md,'../Exp/SquareShelf.exp','')
md=parameterize(md,'../Par/SquareSheetShelf.py')
md=setflowequation(md,'macayeal','all')
md.diagnostic.isnewton=1
md.diagnostic.restol=0.0001
md.cluster=generic('name',oshostname(),'np',3)
md=solve(md,DiagnosticSolutionEnum())

#Fields and tolerances to track changes
field_names     =['Vx','Vy','Vel','Pressure']
field_tolerances=[1e-13,1e-13,1e-13,1e-13]
field_values=[\
	md.results.DiagnosticSolution.Vx,\
	md.results.DiagnosticSolution.Vy,\
	md.results.DiagnosticSolution.Vel,\
	md.results.DiagnosticSolution.Pressure,\
	]
