#include <jni.h>
#include "../../../c/android/fac.h"
namespace com_example_issm
{
	static jlong factorial(JNIEnv *env, jclass clazz, jlong n)
	{
		fac *f = new fac();
		jlong result = (jlong) (f->factorial(n));
		delete(f);
		return (jlong) result;
	}
//------------------------------------------------------------------------------------
	static JNINativeMethod method_table[] = {
			{"fac" ,"(J)J" , (void *) factorial},
	};
}

using namespace com_example_issm;

extern "C" jint JNI_OnLoad(JavaVM* vm, void* reserved)
{
    JNIEnv* env;
    if (vm->GetEnv(reinterpret_cast<void**>(&env), JNI_VERSION_1_6) != JNI_OK) {
        return -1;
    }
    else
    {
    	jclass clazz = env->FindClass("com/example/issm/IssmJni");
    	if(clazz)
    	{
    		env->RegisterNatives(clazz, method_table, 1);
    		env->DeleteLocalRef(clazz);
    		return JNI_VERSION_1_6;
    	}
    	else return -1;
    }

    // Get jclass with env->FindClass.
    // Register methods with env->RegisterNatives.
}