/*!\file CreateNodalConstraintsx
 * \brief: establish degrees of freedom for all nodes, and return partitioning vector. Do only once.
 */

#include "./CreateNodalConstraintsx.h"

#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void CreateNodalConstraintsx( Vector<IssmDouble>** pys, Nodes* nodes,int configuration_type){

	bool  oldalloc  = false;

	/*output: */
	Vector<IssmDouble>* ys=NULL;

	/*figure out how many dofs we have: */
	int ssize=nodes->NumberOfDofs(configuration_type,SsetEnum);
	int slocalsize = nodes->NumberOfDofsLocal(configuration_type,SsetEnum);

	/*allocate:*/
	if(oldalloc)
	 ys=new Vector<IssmDouble>(ssize);
	else
	 ys=new Vector<IssmDouble>(slocalsize,ssize);

	/*go through all nodes, and for the ones corresponding to this configuration_type, fill the 
	 * constraints vector with the constraint values: */
	for(int i=0;i<nodes->Size();i++){
		Node* node=(Node*)nodes->GetObjectByOffset(i);
		if (node->InAnalysis(configuration_type)){
			node->CreateNodalConstraints(ys);
		}
	}

	/*Assemble: */
	ys->Assemble();

	/*Assign output pointers: */
	*pys=ys;
}
