import shelve
import os.path

def savevars(*args):
	"""
	SAVEVARS - function to save variables to a file.

	This function saves one or more variables to a file.  The names of the variables
	must be supplied.  If more than one variable is specified, it may be done with
	lists of names and values or a dictionary of name:value pairs.  All the variables
	in the workspace may be saved by specifying the globals() dictionary, but this
	may include a lot of extraneous data.

	Usage:
	   savevars('a',a,'file.dat')
	   savevars(['a','b'],[a,b],'file.dat')
	   savevars({'a':a,'b':b},'file.dat')
	   savevars(globals(),'file.dat')

	"""

	nvdict={}
	filename=''

	if   isinstance(args[0],(str,unicode)):    # (name,value,filename)
		nvdict[args[0]]=args[1]
		if len(args) >= 3 and isinstance(args[2],(str,unicode)):
			filename=args[2]

	elif isinstance(args[0],list):    # ([names],[values],filename)
		for name,value in zip(args[0],args[1]):
			nvdict[name]=value
		if len(args) >= 3 and isinstance(args[2],(str,unicode)):
			filename=args[2]

	elif isinstance(args[0],dict):    # ({names:values},filename)
		nvdict=args[0]
		if len(args) >= 2 and isinstance(args[1],(str,unicode)):
			filename=args[1]

	else:
		raise TypeError("Unrecognized input arguments.")

	if not filename:
		filename='/tmp/shelve.out'
	if os.path.exists(filename):
		print "Shelving variables to existing file '%s'." % filename
	else:
		print "Shelving variables to new file '%s'." % filename

	my_shelf = shelve.open(filename,'c') # 'c' for create if not exist, else 'n' for new

	for name,value in nvdict.iteritems():
		try:
			my_shelf[name] = value
			print "Variable '%s' shelved." % name
		except TypeError:
			print "Variable '%s' not shelved." % name

	my_shelf.close()

