import shelve
import os.path

def loadvars(*args):
	"""
	LOADVARS - function to load variables to a file.

	This function loads one or more variables from a file.  The names of the variables
	must be supplied.  If more than one variable is specified, it may be done with
	a list of names or a dictionary of name as keys.  The output type will correspond
	to the input type.  All the variables in the file may be loaded by specifying an
	empty dictionary.

	Usage:
	   a=loadvars('a','file.dat')
	   [a,b]=loadvars(['a','b'],'file.dat')
	   nvdict=loadvars({'a':None,'b':None},'file.dat')
	   nvdict=loadvars({},'file.dat')

	"""

	nvdict={}
	filename=''

	if   isinstance(args[0],(str,unicode)):    # (name,filename)
		nvdict[args[0]]=None
		if len(args) >= 2 and isinstance(args[1],(str,unicode)):
			filename=args[1]

	elif isinstance(args[0],list):    # ([names],filename)
		for name in args[0]:
			nvdict[name]=None
		if len(args) >= 2 and isinstance(args[1],(str,unicode)):
			filename=args[1]

	elif isinstance(args[0],dict):    # ({names:values},filename)
		nvdict=args[0]
		if len(args) >= 2 and isinstance(args[1],(str,unicode)):
			filename=args[1]

	else:
		raise TypeError("Unrecognized input arguments.")

	if not filename:
		filename='/tmp/shelve.out'
	if os.path.exists(filename):
		print "Loading variables from file '%s'." % filename
	else:
		raise IOError("File '%s' not found." % filename)

	my_shelf = shelve.open(filename,'r') # 'r' for read-only

	if nvdict:
		for name in nvdict.iterkeys():
			try:
				nvdict[name] = my_shelf[name]
				print "Variable '%s' loaded." % name
			except KeyError:
				value = None
				print "Variable '%s' not found." % name

	else:
		for name in my_shelf.iterkeys():
			nvdict[name] = my_shelf[name]
			print "Variable '%s' loaded." % name

	my_shelf.close()

	if   isinstance(args[0],(str,unicode)):    # (name,filename)
		return nvdict[args[0]]

	elif isinstance(args[0],list):    # ([names],filename)
		value=[nvdict[name] for name in args[0]]
		return value

	elif isinstance(args[0],dict):    # ({names:values},filename)
		return nvdict

