/*!\file: Loads.h
 * \brief prototypes for Loads.h
 */ 

#ifndef _CONTAINER_LOADS_H_
#define  _CONTAINER_LOADS_H_

/*forward declarations */
class Materials;
class Parameters;
class Elements;
class Vertices;
class Loads;
class Nodes;
class DataSet;
class Inputs;

class Loads: public DataSet{

	public:

		/*constructors, destructors*/
		Loads();
		~Loads();

		/*numerics*/
		void  Configure(Elements* elements,Loads* loads, Nodes* nodes, Vertices* vertices, Materials* materials,Parameters* parameters);
		bool  IsPenalty(int analysis);
		int   MaxNumNodes(int analysis);
		int   NumberOfLoads(void);
		int   NumberOfLoads(int analysis);
		void  SetCurrentConfiguration(Elements* elements,Loads* loads, Nodes* nodes, Vertices* vertices, Materials* materials,Parameters* parameters);
		int   Size(int analysis);
		int   Size(void);

};

#endif //ifndef _LOADS_H_
