/*!\file: Elements.h
 * \brief prototypes for Elements.h
 */ 

#ifndef _CONTAINER_ELEMENTS_H_
#define  _CONTAINER_ELEMENTS_H_

/*forward declarations */
class Materials;
class Parameters;
class Elements;
class Vertices;
class Loads;
class Nodes;
class DataSet;
class Inputs;

class Elements: public DataSet{

	public:

		/*constructors, destructors*/
		Elements();
		~Elements();

		/*numerics*/
		void   Configure(Elements* elements,Loads* loads, Nodes* nodes, Vertices* vertices, Materials* materials,Parameters* parameters);
		void   DeleteResults(void);
		int    MaxNumNodes(void);
		void   ProcessResultsUnits(void);
		void   SetCurrentConfiguration(Elements* elements,Loads* loads, Nodes* nodes, Vertices* vertices, Materials* materials,Parameters* parameters);
		void   ToResults(Results* results,Parameters* parameters);
		Patch* ResultsToPatch(void);
		int    NumberOfElements(void);
		void   InputDuplicate(int input_enum,int output_enum);

};

#endif //ifndef _ELEMENTS_H_
