from MatlabFuncs import *
from model import *
from EnumDefinitions import *
import numpy
from triangle import *
from setmask import *
from parameterize import *
from setflowequation import *
from solve import *

md=triangle(model(),'../Exp/Square.exp',150000)
md=setmask(md,'all','')
md=parameterize(md,'../Par/SquareShelfConstrained.py')
md=setflowequation(md,'macayeal','all')
md.cluster=generic('name',oshostname(),'np',3)
md.autodiff.isautodiff=true
md=solve(md,PrognosticSolutionEnum())


# Fields and tolerances to track changes

field_names     =['Thickness']
field_tolerances=[1e-13]
field_values=[\
	md.results['PrognosticSolution'][1]['Thickness'],\
	]
