from MatlabFuncs import *
from model import *
from EnumDefinitions import *
import numpy
from triangle import *
from setmask import *
from parameterize import *
from setflowequation import *
from solve import *

md=triangle(model(),'../Exp/Square.exp',50000)
md=setmask(md,'all','')
md=parameterize(md,'../Par/SquareShelfConstrained.py')
md=setflowequation(md,'macayeal','all')
md.cluster=generic('name',oshostname(),'np',3)
md.diagnostic.requested_outputs=StressTensorEnum()
md.autodiff.isautodiff=true
md=solve(md,DiagnosticSolutionEnum())


# Fields and tolerances to track changes

field_names     =['Vx','Vy','Vel','Pressure',\
	'StressTensorxx','StressTensoryy','StressTensorxy']
field_tolerances=[1e-13,1e-13,1e-13,1e-13,\
	1e-13,1e-13,1e-13]
field_values=[\
	md.results['DiagnosticSolution'][1]['Vx'],\
	md.results['DiagnosticSolution'][1]['Vy'],\
	md.results['DiagnosticSolution'][1]['Vel'],\
	md.results['DiagnosticSolution'][1]['Pressure'],\
	md.results['DiagnosticSolution'][1]['StressTensorxx'],\
	md.results['DiagnosticSolution'][1]['StressTensoryy'],\
	md.results['DiagnosticSolution'][1]['StressTensorxy'],\
	]
