from MatlabFuncs import *
from model import *
from EnumDefinitions import *
from numpy import *
from triangle import *
from setmask import *
from parameterize import *
from setflowequation import *
from solve import *

md=triangle(model(),'../Exp/Square.exp',180000)
md=setmask(md,'all','')
md=parameterize(md,'../Par/SquareShelf.py')
md.extrude(3,2.)
md=setflowequation(md,'stokes','all')
md.cluster=generic('name',oshostname(),'np',3)
md=solve(md,DiagnosticSolutionEnum())


# Fields and tolerances to track changes

field_names     =['Vx','Vy','Vz','Vel','Pressure']
field_tolerances=[1e-08,1e-08,1e-07,1e-08,1e-08]
field_values=[\
	md.results['DiagnosticSolution'][1]['Vx'],\
	md.results['DiagnosticSolution'][1]['Vy'],\
	md.results['DiagnosticSolution'][1]['Vz'],\
	md.results['DiagnosticSolution'][1]['Vel'],\
	md.results['DiagnosticSolution'][1]['Pressure'],\
	]
