from MatlabFuncs import *
from model import *
from EnumDefinitions import *
import numpy
from triangle import *
from setmask import *
from parameterize import *
from setflowequation import *
from solve import *

md=triangle(model(),'../Exp/Square.exp',180000)
md=setmask(md,'all','')
md=parameterize(md,'../Par/SquareShelfConstrained.py')
md.extrude(3,1.)
md=setflowequation(md,'macayeal','all')
md.timestepping.time_step=0
md.cluster=generic('name',oshostname(),'np',3)
md.autodiff.isautodiff=true
md=solve(md,ThermalSolutionEnum())


# Fields and tolerances to track changes

field_names     =['Temperature','BasalforcingsMeltingRate']
field_tolerances=[1e-13,1e-13]
field_values=[\
	md.results['ThermalSolution'][1]['Temperature'],\
	md.results['ThermalSolution'][1]['BasalforcingsMeltingRate'],\
	]
