%INDEPENDENT class definition
%
%   Usage:
%      independent=independent();

classdef independent
	properties (SetAccess=public) 
		name                 = '';
		type                 = '';
		fos_forward_index    = NaN;
		fov_forward_indices  = [];
		nods                 = 0;
	end
	methods
		function obj = independent(varargin) % {{{

			%use provided options to change fields
			options=pairoptions(varargin{:});

			%OK get other fields
			obj=AssignObjectFields(pairoptions(varargin{:}),obj);

		end
		%}}}
		function obj = setdefaultparameters(obj) % {{{
			%do nothing

		end % }}}
		function md = checkconsistency(obj,md,i,solution,analyses,driver) % {{{
			if ~isnan(obj.fos_forward_index),
				if ~strcmpi(driver,'fos_forward'),
					error('cannot declare an independent with a fos_forward_index when the driver is not fos_forward!');
				end
				if obj.nods==0,
					error('independent checkconsistency error: nods should be set to the size of the independent variable');
				end
			end

			if ~isempty(obj.fov_forward_indices),
				if ~strcmpi(driver,'fov_forward'),
					error('cannot declare an independent with fov_forward_indices when the driver is not fov_forward!');
				end
				if obj.nods==0,
					error('independent checkconsistency error: nods should be set to the size of the independent variable');
				end
				md = checkfield(md,['autodiff.independents{' num2str(i) '}.fov_forward_indices'],'>=',1,'<=',obj.nods,'size',[NaN 1]);
			end

		end % }}}
		function disp(obj) % {{{
			disp(sprintf('   independent variable:'));

			fielddisplay(obj,'name','variable name (must match corresponding Enum)');
			fielddisplay(obj,'type','type of variable (''vertex'' or ''scalar'')');
			if ~isnan(obj.fos_forward_index),
				fielddisplay(obj,'fos_forward_index','index for fos_foward driver of ADOLC');
			end
			if ~isnan(obj.fov_forward_indices),
				fielddisplay(obj,'fov_forward_indices','indices for fov_foward driver of ADOLC');
			end
		end % }}}
		function scalar=typetoscalar(obj) % {{{
			if strcmpi(obj.type,'scalar'),
				scalar=0;
			elseif strcmpi(obj.type,'vertex'),
				scalar=1;
			end
		end % }}}
	end
end
