package com.example.issm;

import android.app.Activity;
import android.content.Context;
import android.opengl.GLES20;
import android.opengl.GLSurfaceView;
import android.opengl.GLSurfaceView.Renderer;
import android.os.Bundle;
import android.util.AttributeSet;
import android.view.Menu;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.SeekBar.OnSeekBarChangeListener;
import android.widget.TextView;
import android.widget.Toast;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;	 
import java.nio.ShortBuffer;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10; 

public class ISSM extends Activity implements OnSeekBarChangeListener
{
	private SeekBar bar;
    private TextView txtStatus, txtValue;
    private GLSurfaceView mGLView;
	private FrameLayout frame;
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_issm);
        
        bar = (SeekBar)findViewById(R.id.seekBar); // make seekbar object
        bar.setOnSeekBarChangeListener(this); // set seekbar listener
        txtValue = (TextView)findViewById(R.id.value);
        txtStatus = (TextView)findViewById(R.id.status);
        
        mGLView = new MyGLSurfaceView(this);
        frame = (FrameLayout)findViewById(R.id.frame);
        frame.addView(mGLView);

    }


	@Override
    public void onProgressChanged(SeekBar seekBar, int val,
    		boolean fromUser) 
    {
    	// change progress text label with current Seekbar value
    	txtValue.setText("Value: " + val);
    	txtStatus.setText("Status: changing");
    }
    @Override
    public void onStartTrackingTouch(SeekBar seekBar) 
    {
    	txtStatus.setText("Status: Starting to track touch");

    }
    @Override
    public void onStopTrackingTouch(SeekBar seekBar) 
    {
    	seekBar.setSecondaryProgress(seekBar.getProgress()); // set the shade of the previous value.
    	txtStatus.setText("Status: Ended tracking touch");
    }
    
    @Override
    protected void onPause() {
        super.onPause();
        // The following call pauses the rendering thread.
        // If your OpenGL application is memory intensive,
        // you should consider de-allocating objects that
        // consume significant memory here.
        mGLView.onPause();
    }
    
    @Override
    protected void onResume() {
        super.onResume();
        // The following call resumes a paused rendering thread.
        // If you de-allocated graphic objects for onPause()
        // this is a good place to re-allocate them.
        mGLView.onResume();
    }

    
    @Override
    public boolean onCreateOptionsMenu(Menu menu) 
    {
        getMenuInflater().inflate(R.menu.activity_issm, menu);
        return true;
    }
}
