#!/bin/bash

##Some cleanup
#rm -rf install petsc-3.3-p2 src
#mkdir install src
#
##Download from ISSM server
#$ISSM_DIR/scripts/DownloadExternalPackage.py 'http://issm.jpl.nasa.gov/files/externalpackages/petsc-lite-3.3-p2.tar.gz' 'petsc-3.3-p2.tar.gz'
#
##Untar and move petsc to install directory
#tar -zxvf  petsc-3.3-p2.tar.gz
#mv petsc-3.3-p2/* src/
#rm -rf petsc-3.3-p2

#configure
cd src
./config/configure.py \
 --prefix="$ISSM_DIR/externalpackages/petsc/install" \
 --PETSC_DIR="$ISSM_DIR/externalpackages/petsc/src" \
 --with-debugging=0 \
 --with-shared-libraries=1 \
 --with-blas-lapack-dir=/opt/intel/mkl/10.0.1.014/ \
 --known-mpi-shared-libraries=1 \
 --with-mpi=1 \
 --download-mumps=yes \
 --download-blacs=yes  \
 --download-blas=yes \
 --download-f-blas-lapack=yes \
 --download-parmetis=yes \
 --download-metis=yes \
 --download-trilinos=yes \
 --download-euclid=yes \
 --download-spai=yes \
 --download-superlu=yes \
 --download-hypre=yes \
 --download-prometheus=yes \
 --with-cc=/opt/mpich/ch-p4/bin/mpicc \
 --with-cxx=/opt/mpich/ch-p4/bin/mpicxx \
 --with-fc=/opt/mpich/ch-p4/bin/mpif90 \
 --COPTFLAGS="-I/opt/mpich/ch-p4/include/ -lmpich -O3" \
 --FOPTFLAGS="-I/opt/mpich/ch-p4/include/ -lmpich -O3" \
 --CXXOPTFLAGS="-I/opt/mpich/ch-p4/include/ -lmpich -O3" 
