#!/usr/bin/env python
# STARTUP - Python startup script
#
#  startup.py is a script run by python at the beginning of a session, just
#  before handing over the prompt to the user if the environment variable
#  PYTHONSTARTUP is defined:
#  export PYTHONSTARTUP=$ISSM_DIR/startup.py
#  This startup script should be run by users before trying to use ISSM.

import os,sys

#Recover ISSM_DIR and USERNAME
ISSM_DIR=os.getenv('ISSM_DIR')
USERNAME =os.getenv('USER')
if(ISSM_DIR==None):
	raise NameError('"ISSM_DIR" environment variable is empty! You should define ISSM_DIR in your .cshrc or .bashrc!')

#Go through src/m and append any directory that contains a *.py file to PATH 
for root,dirs,files in os.walk(ISSM_DIR+ '/src/m'):
	if '.svn' in dirs:
		dirs.remove('.svn')
	for file in files:
		if file.find(".py") != -1:
			if file.find(".pyc") == -1:
				if root not in sys.path:
					sys.path.append(root)
				
sys.path.append(ISSM_DIR + '/lib')

print("\n  To get started with ISSM, type issmdoc at the command prompt.\n\n")
