/*!\file SmearFunctionx
 * \brief: create 
 */

#include "./SmearFunctionx.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../io/io.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void SmearFunctionx(Vec* psmearedvector,double (*WeightFunction)(double distance,double radius), int SmearedFieldEnum, double radius,Elements* elements,Nodes* nodes, Parameters* parameters){

	Element *element = NULL;
	Vec x=NULL;
	Vec y=NULL;
	Vec z=NULL;
	Vec smearedvector=NULL;
	int i;

	double* x_serial=NULL;
	double* y_serial=NULL;
	double* z_serial=NULL;

	/*retrive parameters: */
	parameters->FindParam(&configuration_type,ConfigurationTypeEnum);

	/*allocate: */
	gsize=nodes->NumberOfDofs(configuration_type,GsetEnum);
	smearedvector=NewVec(gsize,IssmComm::GetComm());

	x=NewVec(gsize,IssmComm::GetComm());
	y=NewVec(gsize,IssmComm::GetComm());
	z=NewVec(gsize,IssmComm::GetComm());

	for(i=0;i<nodes->Size();i++){

	}

	/*Fill smearedvector vector: */
	for (i=0;i<elements->Size();i++){
		element=dynamic_cast<Element*>(elements->GetObjectByOffset(i));
		element->SmearFunction(smearedvector,WeightFunction,SmearedFieldEnum,radius);
	}

	VecAssemblyBegin(smearedvector);
	VecAssemblyEnd(smearedvector);

	/*Assign output pointers: */
	*psmearedvector=smearedvector;

}
