/*!\file ComputeBasalStressx
 * \brief: compute pressure according to each element
 */

#include "./ComputeBasalStressx.h"

#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void	ComputeBasalStressx( Vector<IssmDouble>** psigma,Elements* elements,Nodes* nodes, Vertices* vertices,Loads* loads, Materials* materials,Parameters* parameters){

	/*Intermediary*/
	int i;
	int      found=0;
	IssmDouble   numberofelements;
	Element* element=NULL;

	/*output: */
	Vector<IssmDouble>* sigma=NULL;

	/*Recover numberofelements: */
	parameters->FindParam(&numberofelements,MeshNumberofelementsEnum);

	/*Allocate sigma on numberofelements: */
	sigma=new Vector<IssmDouble>(reCast<int>(numberofelements));

	/*Compute basal stress for each element: */
	for (i=0;i<elements->Size();i++){
		element=dynamic_cast<Element*>(elements->GetObjectByOffset(i));
		element->ComputeBasalStress(sigma);
	}

	/*Assemble vector: */
	sigma->Assemble();

	/*Assign output pointers: */
	*psigma=sigma;

}
