/*!\file MinVzx
 */

#include "./MinVzx.h"

#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void MinVzx( IssmDouble* pminvz, Elements* elements,Nodes* nodes, Vertices* vertices, Loads* loads, Materials* materials,Parameters* parameters,bool process_units){

	int i;
	IssmDouble minvz;
	IssmDouble node_minvz;
	IssmDouble element_minvz;

	/*Go through elements, and request velocity: */
	for(i=0;i<elements->Size();i++){
		Element* element=dynamic_cast<Element*>(elements->GetObjectByOffset(i));
		element->MinVz(&element_minvz,process_units); //go pick up the minimum velocity in the inputs

		if(i==0)minvz=element_minvz; //initialize minvz
		else{
			if(element_minvz<minvz)minvz=element_minvz;
		}
	}
	/*A safeguard in case: */
	if(elements->Size()==0){
		minvz=INFINITY;
	}

	/*Figure out minimum across the cluster: */
	#ifdef _HAVE_MPI_
	MPI_Reduce (&minvz,&node_minvz,1,MPI_DOUBLE,MPI_MIN,0,IssmComm::GetComm() );
	MPI_Bcast(&node_minvz,1,MPI_DOUBLE,0,IssmComm::GetComm());   
	minvz=node_minvz;
	#endif

	/*Assign output pointers:*/
	*pminvz=minvz;
}
