/*!\file MinVyx
 */

#include "./MinVyx.h"

#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void MinVyx( IssmDouble* pminvy, Elements* elements,Nodes* nodes, Vertices* vertices, Loads* loads, Materials* materials,Parameters* parameters,bool process_units){

	int i;
	IssmDouble minvy;
	IssmDouble node_minvy;
	IssmDouble element_minvy;

	/*Go through elements, and request velocity: */
	for(i=0;i<elements->Size();i++){
		Element* element=dynamic_cast<Element*>(elements->GetObjectByOffset(i));
		element->MinVy(&element_minvy,process_units); //go pick up the minimum velocity in the inputs

		if(i==0)minvy=element_minvy; //initialize minvy
		else{
			if(element_minvy<minvy)minvy=element_minvy;
		}
	}
	/*A safeguard in case: */
	if(elements->Size()==0){
		minvy=INFINITY;
	}

	/*Figure out minimum across the cluster: */
	#ifdef _HAVE_MPI_
	MPI_Reduce (&minvy,&node_minvy,1,MPI_DOUBLE,MPI_MIN,0,IssmComm::GetComm() );
	MPI_Bcast(&node_minvy,1,MPI_DOUBLE,0,IssmComm::GetComm());   
	minvy=node_minvy;
	#endif

	/*Assign output pointers:*/
	*pminvy=minvy;
}
