/* \file PetscVectorToDoubleVector.cpp
 */

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <string>

/*Petsc includes: */
#include <petscmat.h>
#include <petscvec.h>
#include <petscksp.h>

#include "../../../shared/shared.h"

void PetscVectorToDoubleVector(double** pvector, int* prows, Vec petsc_vector){

	int     rows;
	double *vector = NULL;

	/*Get size of vector: */
	if(petsc_vector){
		VecGetSize(petsc_vector,&rows);
		if(rows){
			int* idxm=xNew<int>(rows);
			vector=xNew<double>(rows);
			for(int i=0;i<rows;i++)idxm[i]=i;
			VecGetValues(petsc_vector,rows,idxm,vector);
			xDelete<int>(idxm);
		}
	}
	else{
		rows=0;
	}

	/*Assign output pointers: */
	*pvector=vector;
	*prows=rows;
}
