#!/bin/sh

#petsc 3.2
#mpich 1.4

./configure \
	--prefix=$ISSM_DIR \
	--with-matlab-dir=$MATLAB_DIR \
	--with-triangle-dir=$ISSM_DIR/externalpackages/triangle/install \
	--with-metis-dir=$ISSM_DIR/externalpackages/metis/install \
	--with-mpi-include=$ISSM_DIR/externalpackages/mpich2/install/include  \
	--with-mpi-lib="-L$ISSM_DIR/externalpackages/mpich2/install/lib/ -lmpich" \
	--with-petsc-dir=$ISSM_DIR/externalpackages/petsc/install \
	--with-python-dir=$ISSM_DIR/externalpackages/python/install\
	--with-python-numpy-dir=$ISSM_DIR/externalpackages/python/install/lib/python2.7/site-packages/numpy/core/include/numpy\
	--with-tao-dir=$ISSM_DIR/externalpackages/tao/install \
	--with-petsc-arch=$ISSM_ARCH \
	--with-mumps-dir=$ISSM_DIR/externalpackages/petsc/install/ \
	--with-dakota-dir=$ISSM_DIR/externalpackages/dakota/install \
	--with-blas-lapack-dir=$ISSM_DIR/externalpackages/petsc/install \
	--with-blacs-dir=$ISSM_DIR/externalpackages/petsc/install/ \
	--with-chaco-dir="$ISSM_DIR/externalpackages/chaco/install" \
	--with-scotch-dir="$ISSM_DIR/externalpackages/scotch/install" \
	--with-graphics-lib=/usr/lib64/libX11.so \
	--with-cxxoptflags="-mtune=barcelona -ffast-math -O3 -msse4.2 -Wno-write-strings "\
	--with-numthreads=18 \
	--enable-debugging 
