/*!\file TriaSearchx
 */

#include "./TriaSearchx.h"

#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../classes/objects/objects.h"
#include "../modules.h"

using namespace bamg;
using namespace std;

void TriaSearchx(double** ptria,int* index,int nel, double* x, double* y, int nods,double* x0, double* y0,int numberofnodes){

	/*Output*/
	double* tria=NULL;

	/*allocate: */
	tria=xNew<double>(numberofnodes);

	/*Intermediary*/
	R2     r;
	I2     I;
	int    i;
	Icoor2 dete[3];

	/* read background mesh */
	Mesh Th(index,x,y,nods,nel); 
	Th.CreateSingleVertexToTriangleConnectivity();

	for(i=0;i<numberofnodes;i++){

		//Get current point coordinates
		r.x=x0[i]; r.y=y0[i];

		I=Th.R2ToI2(r);

		//Find triangle holding r/I
		Triangle &tb=*Th.TriangleFindFromCoord(I,dete);

		// internal point 
		if (Th.GetId(tb)<nel)tria[i]=(double)Th.GetId(tb);
		//external point
		else tria[i]=NAN;
	}

	/*Assign output pointers:*/
	*ptria=tria;
}
