/*!\file Observation.c
 * \brief: implementation of the Observation object
 */

#include <stdlib.h>
#include "../objects/objects.h"

/*Observation constructors and destructor*/
/*FUNCTION Observation::Observation(){{{*/
Observation::Observation(){
	return;
}
/*}}}*/
/*FUNCTION Observation::Observation(double x,double y,int xi,int yi,int index,double value){{{*/
Observation::Observation(double x_in,double y_in,int xi_in,int yi_in,int index_in,double value_in){

	this->x      = x_in;
	this->y      = y_in;
	this->xi     = xi_in;
	this->yi     = yi_in;
	this->index  = index_in;
	this->value  = value_in;
	this->weight = 1.;

}
/*}}}*/
/*FUNCTION Observation::~Observation(){{{*/
Observation::~Observation(){
	return;
}
/*}}}*/

/*Object virtual functions definitions:*/
/*FUNCTION Observation::Echo {{{*/
void Observation::Echo(void){

	_printLine_("Observation");
	_printLine_("   index : " << this->index);
	_printLine_("   x     : " << this->x);
	_printLine_("   y     : " << this->y);
	_printLine_("   xi    : "); printbinary(this->xi); _printLine_("");
	_printLine_("   yi    : "); printbinary(this->yi); _printLine_("");
	_printLine_("   weight: " << this->weight);
	_printLine_("   value : " << this->value);
}
/*}}}*/

/*Observations functions*/
/*FUNCTION Observation::WriteXYObs(double* px,double* py,double* pobs){{{*/
void Observation::WriteXYObs(double* px,double* py,double* pobs){
	*px   = this->x;
	*py   = this->y;
	*pobs = this->value;
}
/*}}}*/
