/*!\file:  EnvironmentFinalize.cpp
 * \brief: finalize Petsc, MPI, you name it
 */ 
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif
#include "../include/include.h"
#include "../toolkits/toolkits.h"
#include "../shared/shared.h"

void EnvironmentFinalize(void){

	int my_rank=0;
	#ifdef _HAVE_MPI_
	/*Make sure we are all here!)*/
	MPI_Barrier(MPI_COMM_WORLD);
	
	/*Print closing statement: */
	#ifdef _HAVE_MPI_
	MPI_Comm_rank(MPI_COMM_WORLD,&my_rank);
	#endif
	if(!my_rank) printf("closing MPI\n");

	/*Finalize: */
	MPI_Finalize();
	#endif
}
