/*! \file IssmComm.cpp
 * \brief  file containing the methods for IssmComm.h
 */

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "./IssmComm.h"
#include "../include/types.h"

void IssmComm::SetComm(COMM incomm){ /*{{{*/
	comm=incomm;
}/*}}}*/
COMM IssmComm::GetComm(){  /*{{{*/
	return comm;
}/*}}}*/
int IssmComm::GetRank(){  /*{{{*/
	int my_rank = 0;

	/*for matlab and python modules, comm == -1*/
	if((int)comm==-1) return my_rank;

	#ifdef _HAVE_MPI_
	MPI_Comm_rank(comm,&my_rank);
	#endif

	return my_rank;

}/*}}}*/
int IssmComm::GetSize(){  /*{{{*/

	int size = 1;

	/*for matlab and python modules, comm == -1*/
	if((int)comm==-1) return size;

	#ifdef _HAVE_MPI_
	MPI_Comm_size(comm,&size);
	#endif

	return size;

}/*}}}*/
