import numpy
from model import *
from EnumDefinitions import *
from MatlabFuncs import *
from triangle import *
from setmask import *
from parameterize import *
from setflowequation import *
from solve import *

md=triangle(model(),'../Exp/Square.exp',150000.)
md=setmask(md,'../Exp/SquareShelf.exp','')
md=parameterize(md,'../Par/SquareSheetShelf.py')
md.extrude(3,2.)
md=setflowequation(md,'macayeal','all')
md.cluster=generic('name',oshostname(),'np',3)
md.timestepping.time_step=0.
md.thermal.isenthalpy=1
md.initialization.waterfraction=numpy.zeros((md.mesh.numberofvertices,1))
md=solve(md,SteadystateSolutionEnum())

#Fields and tolerances to track changes
field_names     =['Vx','Vy','Vz','Vel','Pressure','Temperature','Water fraction','Enthalpy']
field_tolerances=[1e-10,1e-10,1e-09,1e-10,1e-13,1e-10,1e-10,1e-10]
field_values=[\
	md.results['SteadystateSolution'][1]['Vx'],\
	md.results['SteadystateSolution'][1]['Vy'],\
	md.results['SteadystateSolution'][1]['Vz'],\
	md.results['SteadystateSolution'][1]['Vel'],\
	md.results['SteadystateSolution'][1]['Pressure'],\
	md.results['SteadystateSolution'][1]['Temperature'],\
	md.results['SteadystateSolution'][1]['Waterfraction'],\
	md.results['SteadystateSolution'][1]['Enthalpy'],\
	]
