import numpy
from model import *
from EnumDefinitions import *
from MatlabFuncs import *
from triangle import *
from setmask import *
from parameterize import *
from setflowequation import *
from solve import *

md=triangle(model(),'../Exp/Square.exp',150000.)
md=setmask(md,'../Exp/SquareShelf.exp','')
md=parameterize(md,'../Par/SquareSheetShelf.py')
md.extrude(4,1.)
md=setflowequation(md,'pattyn','all')
md.cluster=generic('name',oshostname(),'np',3)
md.timestepping.time_step=0.
md=solve(md,ThermalSolutionEnum())

#Fields and tolerances to track changes
field_names     =['Temperature','BasalforcingsMeltingRate']
field_tolerances=[1e-13,1e-13]
field_values=[\
	md.results['ThermalSolution'][1]['Temperature'],\
	md.results['ThermalSolution'][1]['BasalforcingsMeltingRate'],\
	]
