from model import *
from triangle import *
from setmask import *
from parameterize import *
from setflowequation import *
from EnumDefinitions import *
from solve import *
from MatlabFuncs import *

md=triangle(model(),'../Exp/Square.exp',180000.)
md=setmask(md,'','')
md=parameterize(md,'../Par/SquareSheetConstrained.py')
md.extrude(3,1.)
md=setflowequation(md,'pattyn','all')
md.cluster=generic('name',oshostname(),'np',3)
md=solve(md,DiagnosticSolutionEnum())

#Fields and tolerances to track changes
field_names     =['Vx','Vy','Vz','Vel','Pressure']
field_tolerances=[1e-09,1e-09,2e-10,2e-10,1e-10]
field_values=[\
	md.results['DiagnosticSolution'][1]['Vx'],\
	md.results['DiagnosticSolution'][1]['Vy'],\
	md.results['DiagnosticSolution'][1]['Vz'],\
	md.results['DiagnosticSolution'][1]['Vel'],\
	md.results['DiagnosticSolution'][1]['Pressure'],\
	]
