md=triangle(model(),'../Exp/Square.exp',150000.);
md=setmask(md,'','');
md=parameterize(md,'../Par/SquareSheetConstrained.par');
md=extrude(md,3,1.);
md=setflowequation(md,'pattyn','all');
md.surfaceforcings.issmbgradients=1;
md.surfaceforcings.smb_pos_max=5000. - 0.00005*md.mesh.x + 0.0001*md.mesh.y;
md.surfaceforcings.smb_pos_min=1250. + 0.00005*md.mesh.x -0.0001*md.mesh.y;
md.surfaceforcings.a_pos=15000. - 0.000051*md.mesh.x + 0.00011*md.mesh.y;
md.surfaceforcings.b_pos=-100. + 0.00005*md.mesh.x - 0.0001*md.mesh.y;
md.surfaceforcings.a_neg=-20000. - 0.00005*md.mesh.x + 0.0001*md.mesh.y;
md.surfaceforcings.b_neg=250. + 0.000051*md.mesh.x - 0.00011*md.mesh.y;
md.surfaceforcings.hc=(md.surfaceforcings.a_pos-md.surfaceforcings.a_neg)./(md.surfaceforcings.b_neg-md.surfaceforcings.b_pos);
md.surfaceforcings.href=md.geometry.surface;
for i=1:size(md.surfaceforcings.hc),
	if md.geometry.surface(i)<md.surfaceforcings.hc(i)
		smbref(i)=md.surfaceforcings.a_neg(i)+md.surfaceforcings.b_neg(i)*md.geometry.surface(i);
	else
		smbref(i)=md.surfaceforcings.a_pos(i)+md.surfaceforcings.b_pos(i)*md.geometry.surface(i);
	end
end
md.surfaceforcings.smbref=smbref';
md.transient.requested_outputs=TotalSmbEnum();
md.cluster=generic('name',oshostname(),'np',3);
md=solve(md,TransientSolutionEnum());

%Fields and tolerances to track changes
field_names     ={'Vx1','Vy1','Vz1','Vel1','Bed1','Surface1','Thickness1','Temperature1','SMB1','TotalSmb1','Vx2','Vy2','Vz2','Vel2','Bed2','Surface2','Thickness2','Temperature2','SMB2','TotalSmb1','Vx3','Vy3','Vz3','Vel3','Bed3','Surface3','Thickness3','Temperature3','SMB3','TotalSmb1'};
field_tolerances={1e-09,1e-09,1e-09,1e-09,1e-10,1e-10,1e-10,1e-10,1e-10,1e-10,...
						1e-09,1e-09,1e-10,1e-09,1e-10,1e-10,1e-10,1e-10,1e-10,1e-10,...
						1e-09,5e-09,1e-09,1e-09,1e-10,1e-10,1e-10,1e-10,1e-10,1e-10};

field_values={...
	(md.results.TransientSolution(1).Vx),...
	(md.results.TransientSolution(1).Vy),...
	(md.results.TransientSolution(1).Vz),...
	(md.results.TransientSolution(1).Vel),...
	(md.results.TransientSolution(1).Bed),...
	(md.results.TransientSolution(1).Surface),...
	(md.results.TransientSolution(1).Thickness),...
	(md.results.TransientSolution(1).Temperature),...
	(md.results.TransientSolution(1).SurfaceforcingsMassBalance),...
	(md.results.TransientSolution(1).TotalSmb),...
	(md.results.TransientSolution(2).Vx),...
	(md.results.TransientSolution(2).Vy),...
	(md.results.TransientSolution(2).Vz),...
	(md.results.TransientSolution(2).Vel),...
	(md.results.TransientSolution(2).Bed),...
	(md.results.TransientSolution(2).Surface),...
	(md.results.TransientSolution(2).Thickness),...
	(md.results.TransientSolution(2).Temperature),...
	(md.results.TransientSolution(2).SurfaceforcingsMassBalance),...
	(md.results.TransientSolution(2).TotalSmb),...
	(md.results.TransientSolution(3).Vx),...
	(md.results.TransientSolution(3).Vy),...
	(md.results.TransientSolution(3).Vz),...
	(md.results.TransientSolution(3).Vel),...
	(md.results.TransientSolution(3).Bed),...
	(md.results.TransientSolution(3).Surface),...
	(md.results.TransientSolution(3).Thickness),...
	(md.results.TransientSolution(3).Temperature),...
	(md.results.TransientSolution(3).SurfaceforcingsMassBalance),...
	(md.results.TransientSolution(3).TotalSmb),...
	};
