md=triangle(model(),'../Exp/Square.exp',50000.);
md=setmask(md,'all','');
md=parameterize(md,'../Par/SquareShelfConstrained.par');
md=setflowequation(md,'macayeal','all');
md.cluster=generic('name',oshostname(),'np',3);
md.diagnostic.requested_outputs=StressTensorEnum();
md.autodiff.isautodiff=true;
md.verbose=verbose('autodiff',true);
md=solve(md,DiagnosticSolutionEnum());

%Fields and tolerances to track changes
field_names     ={'Vx','Vy','Vel','Pressure',...
	'StressTensorxx','StressTensoryy','StressTensorxy'};
field_tolerances={1e-13,1e-13,1e-13,1e-13,...
	1e-13,1e-13,1e-13};
field_values={...
	(md.results.DiagnosticSolution.Vx),...
	(md.results.DiagnosticSolution.Vy),...
	(md.results.DiagnosticSolution.Vel),...
	(md.results.DiagnosticSolution.Pressure),...
	(md.results.DiagnosticSolution.StressTensorxx),...
	(md.results.DiagnosticSolution.StressTensoryy),...
	(md.results.DiagnosticSolution.StressTensorxy),...
	};
