md=triangle(model(),'../Exp/Square.exp',180000.);
md=setmask(md,'all','');
md=parameterize(md,'../Par/SquareShelfConstrained.par');
md=extrude(md,3,1);
md=setflowequation(md,'macayeal','all');
md.timestepping.time_step=0;
md.cluster=generic('name',oshostname(),'np',3);
md=solve(md,ThermalSolutionEnum());

%Fields and tolerances to track changes
field_names     ={'Temperature','BasalforcingsMeltingRate'};
field_tolerances={1e-13,1e-13};
field_values={...
	(md.results.ThermalSolution.Temperature),...
	(md.results.ThermalSolution.BasalforcingsMeltingRate),...
	};
