import numpy
from model import *
from EnumDefinitions import *
from MatlabFuncs import *
from triangle import *
from setmask import *
from parameterize import *
from setflowequation import *
from solve import *

md=triangle(model(),'../Exp/79North.exp',10000.)
md=setmask(md,'../Exp/79NorthShelf.exp','')
md=parameterize(md,'../Par/79North.py')
md=setflowequation(md,'macayeal','all')

#control parameters
md.inversion.nsteps=2
md.prognostic.stabilization=1
md.inversion.iscontrol=1
md.inversion.control_parameters=['BalancethicknessThickeningRate']
md.inversion.thickness_obs=md.geometry.thickness
md.inversion.min_parameters=-50.*numpy.ones((md.mesh.numberofvertices,1))
md.inversion.max_parameters=50.*numpy.ones((md.mesh.numberofvertices,1))
md.inversion.cost_functions=201*numpy.ones((md.inversion.nsteps,1))
md.inversion.cost_functions_coefficients=numpy.ones((md.mesh.numberofvertices,1))
md.inversion.gradient_scaling=10./md.constants.yts*numpy.ones((md.inversion.nsteps,1))
md.inversion.maxiter_per_step=4*numpy.ones((md.inversion.nsteps,1))
md.inversion.step_threshold=0.99*numpy.ones((md.inversion.nsteps,1))

md.cluster=generic('name',oshostname(),'np',3)
md=solve(md,BalancethicknessSolutionEnum())

#Fields and tolerances to track changes
field_names     =['Gradient','Misfits','BalancethicknessThickeningRate','Thickness']
field_tolerances=[1e-12,1e-12,1e-12,1e-12,1e-12,1e-12]
field_values=[\
	md.results['BalancethicknessSolution'][1]['Gradient1'],\
	md.results['BalancethicknessSolution'][1]['J'],\
	md.results['BalancethicknessSolution'][1]['BalancethicknessThickeningRate'],\
	md.results['BalancethicknessSolution'][1]['Thickness']
]
