md=triangle(model(),'../Exp/Square.exp',350000);
md=setmask(md,'../Exp/SquareShelf.exp','');
md=parameterize(md,'../Par/SquareSheetShelf.par');
md.initialization.vx(:)=0;
md.initialization.vy(:)=0;
md.initialization.vel(:)=0;
md.geometry.bed=-700-abs(md.mesh.y-500000)/1000;
md.geometry.bathymetry=-700-abs(md.mesh.y-500000)/1000;
md.geometry.thickness(:)=1000;
md.geometry.surface=md.geometry.bed+md.geometry.thickness;
md.surfaceforcings.mass_balance(:)=100;
md=extrude(md,3,1);
md=setflowequation(md,'macayeal','all');

md.transient.isdiagnostic=0;
md.transient.isgroundingline=1;
md.groundingline.migration='AgressiveMigration';
md.cluster=generic('name',oshostname(),'np',3);

md=solve(md,TransientSolutionEnum());

%Fields and tolerances to track changes
field_names     ={'Bed1','Surface1','Thickness1','Floatingice1',...
	'Bed2','Surface2','Thickness2','Floatingice2',...
	'Bed3','Surface3','Thickness3','Floatingice3'};
field_tolerances={1e-13,1e-13,1e-13,1e-13,...
	1e-11,1e-11,1e-11,1e-13,...
	1e-10,1e-10,1e-10,1e-13};
field_values={...
	(md.results.TransientSolution(1).Bed),...
	(md.results.TransientSolution(1).Surface),...
	(md.results.TransientSolution(1).Thickness),...
	(md.results.TransientSolution(1).MaskElementonfloatingice),...
	(md.results.TransientSolution(2).Bed),...
	(md.results.TransientSolution(2).Surface),...
	(md.results.TransientSolution(2).Thickness),...
	(md.results.TransientSolution(2).MaskElementonfloatingice),...
	(md.results.TransientSolution(3).Bed),...
	(md.results.TransientSolution(3).Surface),...
	(md.results.TransientSolution(3).Thickness),...
	(md.results.TransientSolution(3).MaskElementonfloatingice),...
	};
