/*!\file KMLOverlay.h
 * \brief: prototype for KML file overlay mex module.
 */

#ifndef _KMLOVERLAY_H
#define _KMLOVERLAY_H

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
	#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

/*For python modules: needs to come before header files inclusion*/
#ifdef _HAVE_PYTHON_
#define PY_ARRAY_UNIQUE_SYMBOL PythonIOSymbol
#endif

#include "../../c/include/globals.h"
#include "../../c/modules/modules.h"
#include "../../c/Container/Container.h"
#include "../../c/shared/shared.h"
#include "../../c/issm-binding.h"

#undef __FUNCT__ 
#define __FUNCT__  "KMLOverlay"

#ifdef _HAVE_MATLAB_MODULES_
/* serial input macros: */
#define FILENAME  prhs[0]
/* serial output macros: */
#define ERRORFLAG (mxArray**)&plhs[0]
#endif

#ifdef _HAVE_PYTHON_MODULES_
/* serial input macros: */
#define FILENAME  PyTuple_GetItem(args,0)
/* serial output macros: */
#define ERRORFLAG output,0
#endif

/* serial arg counts: */
#undef NRHS
#define NRHS  1
#undef NLHS
#define NLHS  1

#endif
