function expcreatecontour(filename);
%EXPCREATECONTOUR - create a contour from a list of points
%
%   expcreatecontour: from a list of (x,y) points (retrieve using ginput on an undetermined
%   number of points: used RETURN key to end input), create an Argus .exp 
%   file holding the corresponding closed contour.
%    
%   Usage:
%      expcreatecontour(filename)
%
%   See also EXPMASTER, EXPDOC

%Get root of filename
[path root ext ver]=fileparts(filename);

%Get contour
disp('Click on contour points you desire. Type RETURN to end input of points');
[x,y]=ginput();

%close contour
x=[x;x(1)];
y=[y;y(1);];

%plot contour
hold on;
plot(x,y,'r-');

%create structure for expwrite routine
a.x=x;
a.y=y;
a.name=root;
a.density=1;

%write contour using expwrite
expwrite(a,filename);
